import { View, Text, TouchableOpacity } from "react-native";
import React from "react";
import MinusIcon from "../../../../../assets/svgs/cart/minus.svg";
import PlusIcon from "../../../../../assets/svgs/cart/plus.svg";
import { productDetailsStyle } from "../ProductDetailsStyle";
import dpr from "../../../../Utilities/CustomStyleAttribute/dpr";
import CustomSVG from "../../../../../src/components/CustomSVG/CustomSVG";

const ItemQuantity = ({ meta, stockManage, quantity, setQuantity }) => {
    const { stock_status, stock_quantity, backorders } = stockManage || {};
    const { individual_sale } = meta || {};
    const handleIncrement = () => {
        if (
            stock_status.toLowerCase() != "out of stock" ||
            backorders == 1 ||
            quantity < stock_quantity
        ) {
            setQuantity(quantity + 1);
        }
    };
    const handleDecrement = () => {
        if (quantity <= 1) setQuantity(1);
        else setQuantity(quantity - 1);
    };
    let isQuantityIncrease =
        (backorders != 1 && quantity == stock_quantity) || individual_sale == 1;
    return (
        <View style={productDetailsStyle.quantityCont}>
            <TouchableOpacity
                disabled={quantity <= 1 ? true : false}
                onPress={handleDecrement}
                style={productDetailsStyle.quantityIcon}
            >
                <CustomSVG svgIcon={MinusIcon}
                    height={dpr(14)}
                    width={dpr(14)}
                    fill={quantity === 1 ? "#DFDFDF" : "#898989"}
                />
            </TouchableOpacity>
            <Text style={productDetailsStyle.quantity}>{quantity}</Text>
            <TouchableOpacity
                disabled={isQuantityIncrease ? true : false}
                onPress={handleIncrement}
                style={productDetailsStyle.quantityIcon}
            >
                <CustomSVG svgIcon={PlusIcon}
                    height={dpr(14)}
                    width={dpr(14)}
                    fill={isQuantityIncrease ? "#DFDFDF" : "#898989"}
                />
            </TouchableOpacity>
        </View>
    );
};

export default ItemQuantity;
